<?php
/*
Plugin Name: مدیریت قیمت و تخفیف
Plugin URI: https://Modireshop.com
Description: آمار موجودی محصولات | افزایش و کاهش درصدی قیمت | اعمال تخفیف روی محصولات | حذف تخفیف‌ها
Version: 5.0
Author: Modireshop.com
Author URI: https://Modireshop.com
License: GPL2
*/

// افزودن منو به پیشخوان وردپرس
function mpd_add_menu() {
    add_menu_page(
        'قیمت و تخفیف',          // عنوان صفحه
        'قیمت و تخفیف',          // عنوان منو
        'manage_options',        // سطح دسترسی
        'management-price-discount', // شناسه منو
        'mpd_page_content',      // تابع نمایش محتوای صفحه
        'dashicons-tag',         // آیکون منو
        99                       // موقعیت در انتهای منو
    );

    // زیرمنوها
    add_submenu_page(
        'management-price-discount',
        '  افزایش و کاهش قیمت  ',
        ' افزایش و کاهش قیمت ',
        'manage_options',
        'change-percentage',
        'mpd_change_percentage_page'
    );

    add_submenu_page(
        'management-price-discount',
        'تخفیف گذاشتن',
        'تخفیف گذاشتن',
        'manage_options',
        'apply-discount',
        'mpd_apply_discount_page'
    );

    add_submenu_page(
        'management-price-discount',
        'حذف تخفیف',
        'حذف تخفیف',
        'manage_options',
        'remove-discount',
        'mpd_remove_discount_page'
    );

    // اضافه کردن استایل برای تغییر رنگ آیکون
    add_action('admin_head', function() {
        echo '<style>
            #toplevel_page_management-price-discount .wp-menu-image.dashicons-tag:before {
                color: #59ffcb !important; /* رنگ سبز روشن */
            }
        </style>';
    });
}
add_action('admin_menu', 'mpd_add_menu');

// محتوای صفحه اصلی
function mpd_page_content() {
    include plugin_dir_path(__FILE__) . 'includes/main-page.php';
}

// محتوای صفحه تغییر درصدی
function mpd_change_percentage_page() {
    include plugin_dir_path(__FILE__) . 'includes/change-percentage.php';
}

// محتوای صفحه اعمال تخفیف
function mpd_apply_discount_page() {
    include plugin_dir_path(__FILE__) . 'includes/apply-discount.php';
}

// محتوای صفحه حذف تخفیف
function mpd_remove_discount_page() {
    include plugin_dir_path(__FILE__) . 'includes/remove-discount.php';
}
