<?php
function get_product_counts() {
    $args = array(
        'post_type'      => 'product',
        'posts_per_page' => -1,
        'post_status'    => 'publish'
    );
    $all_products = get_posts($args);
    
    $available_products = 0;
    $discounted_products = 0;
    
    foreach ($all_products as $product) {
        $product_obj = wc_get_product($product->ID);
        if (!$product_obj) continue;

        // بررسی موجودی
        $is_available = $product_obj->is_in_stock();

        // بررسی تخفیف فقط برای محصولات موجود
        $has_discount = false;
        if ($is_available) {
            if ($product_obj->is_type('simple')) {
                if ($product_obj->is_on_sale()) {
                    $has_discount = true;
                }
            } elseif ($product_obj->is_type('variable')) {
                $variations = $product_obj->get_children();
                foreach ($variations as $variation_id) {
                    $variation = wc_get_product($variation_id);
                    if ($variation && $variation->is_in_stock() && $variation->is_on_sale()) {
                        $has_discount = true;
                        break;
                    }
                }
            }
        }

        if ($is_available) {
            $available_products++;
        }
        if ($has_discount) {
            $discounted_products++;
        }
    }
    
    return [
        'total'      => count($all_products),
        'available'  => $available_products,
        'discounted' => $discounted_products
    ];
}

function modirshop_clear_discounts() {
    $args = array(
        'post_type'      => 'product',
        'posts_per_page' => -1,
        'post_status'    => 'publish'
    );
    $products = get_posts($args);

    foreach ($products as $product) {
        $product_obj = wc_get_product($product->ID);
        if (!$product_obj) {
            continue;
        }

        // Simple products
        if ($product_obj->is_type('simple')) {
            $regular_price = $product_obj->get_regular_price();
            $product_obj->set_sale_price('');
            $product_obj->set_date_on_sale_from(null);
            $product_obj->set_date_on_sale_to(null);
            if (!empty($regular_price)) {
                $product_obj->set_price($regular_price);
            }
            $product_obj->save();
        }

        // Variable products
        if ($product_obj->is_type('variable')) {
            $variations = $product_obj->get_children();
            foreach ($variations as $variation_id) {
                $variation = wc_get_product($variation_id);
                if (!$variation) {
                    continue;
                }
                $regular_price = $variation->get_regular_price();
                $variation->set_sale_price('');
                $variation->set_date_on_sale_from(null);
                $variation->set_date_on_sale_to(null);
                if (!empty($regular_price)) {
                    $variation->set_price($regular_price);
                }
                $variation->save();
            }
        }
    }

    // پاک کردن کش قیمت‌ها
    wc_delete_product_transients();
}

// پردازش درخواست حذف تخفیف
if (isset($_POST['clear_discounts']) && check_admin_referer('clear_discounts_action')) {
    modirshop_clear_discounts();
}

$product_counts = get_product_counts();
?>

<!DOCTYPE html>
<html lang="fa">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>حذف تخفیف</title>
    <link href="https://fonts.googleapis.com/css2?family=Shabnam&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Shabnam', sans-serif;
            background-color: #f4f4f9;
            color: #333;
            direction: rtl;
            padding: 20px;
        }

        .container {
            width: 100%;
            max-width: 1200px;
            margin: 10px auto;
            padding: 20px;
            background-color: #ffffff;
            border-radius: 20px;
        }

        .chart {
            width: 90%;
            max-width: 600px;
            margin: 20px auto;
        }

        h1 {
            text-align: center;
            color: #2d3e50;
        }

        table {
            width: 70%;
            margin: 20px auto;
            border-collapse: collapse;
            background-color: #fff;
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
        }

        th, td {
            border: 1px solid #ddd;
            padding: 15px;
            text-align: center;
            font-size: 20px;
        }

        th {
            background-color: #f7f7f7;
            font-weight: bold;
        }

        .clear-btn {
            display: block;
            width: 250px;
            margin: 20px auto;
            background-color: #ff6347;
            color: white;
            border: none;
            padding: 12px 20px;
            font-size: 18px;
            border-radius: 5px;
            cursor: pointer;
            text-align: center;
            transition: background-color 0.3s ease;
            font-weight: bold;
        }

        .clear-btn:hover {
            background-color: #e5533b;
        }

        .response-message {
            text-align: center;
            margin-top: 20px;
            font-size: 18px;
            padding: 15px;
            border-radius: 5px;
        }

        .success-message {
            background-color: #d4edda;
            color: #155724;
            border: 1px solid #c3e6cb;
        }

        .message-text {
            font-weight: bold;
        }

        @media (max-width: 768px) {
            table {
                width: 100%;
            }
            .clear-btn {
                width: 150px;
            }
        }
    </style>
</head>
<body>
<div class="container">
    <h1>حذف تخفیف</h1>
    <br>
    <form method="post">
        <?php wp_nonce_field('clear_discounts_action'); ?>
        <button type="submit" name="clear_discounts" class="clear-btn">حذف تمامی تخفیف‌ها</button>
    </form>
    <br>
    <?php if (isset($_POST['clear_discounts'])): ?>
    <?php if (check_admin_referer('clear_discounts_action')): ?>
        <div class="response-message success-message">
            <span class="message-text">✅ تخفیف‌ها با موفقیت حذف شدند.</span>
        </div>
    <?php else: ?>
        <div class="response-message error-message">
            <span class="message-text">❌ خطای امنیتی (لطفاً صفحه را رفرش کنید و دوباره امتحان کنید).</span>
        </div>
    <?php endif; ?>
<?php endif; ?>

    <table>
        <tr>
            <th>کل محصولات</th>
            <th>موجود</th>
            <th>تخفیف‌دار</th>
        </tr>
        <tr>
            <td><?php echo $product_counts['total']; ?></td>
            <td><?php echo $product_counts['available']; ?></td>
            <td><?php echo $product_counts['discounted']; ?></td>
        </tr>
    </table>
    <br>
    <div class="chart">
        <canvas id="productsChart"></canvas>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script>
        document.addEventListener("DOMContentLoaded", function() {
            var ctx = document.getElementById("productsChart").getContext("2d");
            var chart = new Chart(ctx, {
                type: "bar",
                data: {
                    labels: ["کل محصولات", "محصولات موجود", "محصولات تخفیف‌دار"],
                    datasets: [{
                        label: "تعداد",
                        data: [<?php echo $product_counts['total']; ?>, <?php echo $product_counts['available']; ?>, <?php echo $product_counts['discounted']; ?>],
                        backgroundColor: ["#2196f3", "#4caf50", "#ff6347"],
                        borderColor: ["#1976d2", "#388e3c", "#e5533b"],
                        borderWidth: 1
                    }]
                },
                options: {
                    responsive: true,
                    plugins: {
                        legend: {
                            position: "top"
                        },
                        title: {
                            display: true,
                            text: "آمار محصولات"
                        }
                    },
                    scales: {
                        y: {
                            beginAtZero: true,
                            title: {
                                display: true,
                                text: "تعداد"
                            }
                        },
                        x: {
                            title: {
                                display: true,
                                text: "دسته‌بندی"
                            }
                        }
                    }
                }
            });
        });
    </script>
</div>
</body>
</html>