<?php 
// نمایش دو div برای محصولات ساده و متغیر
?>

<style>
/* استایل‌ها */
body {
    font-family: Tahoma, Arial, sans-serif;
    direction: rtl;
    background-color: #f0f0f0;
    padding: 20px;
}

.container {
    width: 100%;
    max-width: 1200px;
    margin: 10px auto;
    padding: 20px;
    background-color: #ffffff;
    border-radius: 20px;
}

.green{color:#4CAF50;}
.red{color:#BE3436;}


.products-container {
    display: flex;
    justify-content: space-between;
    flex-wrap: wrap; /* برای ریسپانسیو کردن */
    gap: 20px; /* فاصله بین دو div */
}

.products-container .simple-products,
.products-container .variable-products {
    width: 40%;
    padding: 30px;
    border: 1px solid #ddd;
    border-radius: 10px;
    text-align: center;
    background-color: #fff;
    box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
    margin: 20px;
}

.products-container h3 {
    font-size: 22px;
    margin-bottom: 20px;
    color: #404040;
}

.products-container p {
    font-size: 18px;
    margin: 10px 0;
}

.count-label {
    font-weight: bold;
    font-size: 20px;
    margin-top: 15px;
    display: block;
}

.count-value {
    font-size: 18px;
    color: #555;
}

.availability-status {
    margin-top: 20px;
    display: flex;
    justify-content: space-between;
}

.availability-status p {
    font-size: 16px;
    padding: 10px;
    border-radius: 5px;
    font-weight: bold;
}

/* ریسپانسیو: زمانی که عرض صفحه کمتر از 768px است */
@media (max-width: 768px) {
    .products-container .simple-products,
    .products-container .variable-products {
        width: 100%;
    }
}
</style>


<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

<!-- کانتینر اصلی -->
<div class="container">

    <!-- عنوان صفحه -->
    <h1 style="text-align: center; color: #333; font-size: 28px; margin-bottom: 40px;">آمار محصولات فروشگاه</h1>

<div style="text-align: center; color: #333; font-size: 14px; margin-top: 40px;">
    طراحی شده با ❤️ توسط تیم مدیرشاپ
   <br><br>
    <a href="https://modireshop.com/category/wp-plugins/" target="_blank" style="color: #007bff; text-decoration: none; font-weight: bold;">
     مشاهده دیگر افزونه های فروشگاهی مفید
    </a>
</div>
<br>

    <div class="products-container">
        <!-- محصولات ساده -->
        <div class="simple-products">
            <h3>محصولات ساده</h3>
            <p>
                <?php
                // دریافت محصولات ساده
                $simple_products = wc_get_products(array(
                    'status' => 'publish',
                    'type'   => 'simple',
                    'limit'  => -1, // همه محصولات
                ));
                echo 'تعداد   : <span class="count-value">' . count($simple_products) . '</span>';
                ?>
            </p>

            <!-- موجود و ناموجود محصولات -->
            <div class="availability-status">
                <p class="green"> 
                    موجود:
                    <?php
                    $available_simple_products = array_filter($simple_products, function($product) {
                        $stock_status = $product->get_stock_status(); // وضعیت موجودی
                        $manage_stock = $product->get_manage_stock(); // مدیریت موجودی فعال است؟
                        $stock_quantity = $product->get_stock_quantity(); // تعداد موجودی

                        return $stock_status === 'instock' && (!$manage_stock || ($manage_stock && $stock_quantity > 0));
                    });
                    echo count($available_simple_products);
                    ?>
                </p>

                <p class="red">
                    ناموجود:
                    <?php
                    $out_of_stock_simple_products = array_filter($simple_products, function($product) {
                        $stock_status = $product->get_stock_status(); // وضعیت موجودی
                        $manage_stock = $product->get_manage_stock(); // مدیریت موجودی فعال است؟
                        $stock_quantity = $product->get_stock_quantity(); // تعداد موجودی

                        return !($stock_status === 'instock' && (!$manage_stock || ($manage_stock && $stock_quantity > 0)));
                    });
                    echo count($out_of_stock_simple_products);
                    ?>
                </p>
            </div>
            
            <canvas id="simpleProductsChart"></canvas>


            
        </div>

        <!-- محصولات متغیر -->
        <div class="variable-products">
            <h3>محصولات متغیر</h3>
            <p  >
                <?php
                // دریافت محصولات متغیر
                $variable_products = wc_get_products(array(
                    'status' => 'publish',
                    'type'   => 'variable',
                    'limit'  => -1, // همه محصولات
                ));
                echo 'تعداد  : <span class="count-value">' . count($variable_products) . '</span>';
                ?>
            </p>

            <!-- موجود و ناموجود محصولات -->
            <div class="availability-status">
                <p class="green">
                    موجود:
                    <?php
                    $available_variable_products = array_filter($variable_products, function($product) {
                        $variations = $product->get_children(); // دریافت همه واریانت‌ها
                        foreach ($variations as $variation_id) {
                            $variation = wc_get_product($variation_id);
                            $stock_status = $variation->get_stock_status();
                            $manage_stock = $variation->get_manage_stock();
                            $stock_quantity = $variation->get_stock_quantity();

                            if ($stock_status === 'instock' && (!$manage_stock || ($manage_stock && $stock_quantity > 0))) {
                                return true; // اگر یکی از واریانت‌ها موجود باشد، کل محصول موجود محسوب می‌شود
                            }
                        }
                        return false;
                    });
                    echo count($available_variable_products);
                    ?>
                </p>

                <p class="red">
                    ناموجود:
                    <?php
                    $out_of_stock_variable_products = array_filter($variable_products, function($product) {
                        $variations = $product->get_children();
                        foreach ($variations as $variation_id) {
                            $variation = wc_get_product($variation_id);
                            $stock_status = $variation->get_stock_status();
                            $manage_stock = $variation->get_manage_stock();
                            $stock_quantity = $variation->get_stock_quantity();

                            if ($stock_status === 'instock' && (!$manage_stock || ($manage_stock && $stock_quantity > 0))) {
                                return false; // اگر حداقل یکی از واریانت‌ها موجود باشد، محصول ناموجود محسوب نمی‌شود
                            }
                        }
                        return true;
                    });
                    echo count($out_of_stock_variable_products);
                    ?>
                </p>
            </div>
            
            <canvas id="variableProductsChart"></canvas>
        </div>
    </div>
</div>



<script>
    // داده‌های محصولات ساده
    var availableSimple = <?php echo count($available_simple_products); ?>;
    var outOfStockSimple = <?php echo count($out_of_stock_simple_products); ?>;

    // داده‌های محصولات متغیر
    var availableVariable = <?php echo count($available_variable_products); ?>;
    var outOfStockVariable = <?php echo count($out_of_stock_variable_products); ?>;

    // نمودار محصولات ساده
    var ctxSimple = document.getElementById('simpleProductsChart').getContext('2d');
    var simpleProductsChart = new Chart(ctxSimple, {
        type: 'pie', // نوع نمودار دایره‌ای
        data: {
            labels: ['موجود', 'ناموجود'],
            datasets: [{
                data: [availableSimple, outOfStockSimple],
                backgroundColor: ['#4CAF50', '#BE3436'], // رنگ‌ها برای موجود و ناموجود
            }]
        },
        options: {
            responsive: true,
            plugins: {
                legend: {
                    position: 'top',
                },
                tooltip: {
                    callbacks: {
                        label: function(tooltipItem) {
                            return tooltipItem.label + ': ' + tooltipItem.raw + ' محصول';
                        }
                    }
                }
            }
        }
    });

    // نمودار محصولات متغیر
    var ctxVariable = document.getElementById('variableProductsChart').getContext('2d');
    var variableProductsChart = new Chart(ctxVariable, {
        type: 'pie',
        data: {
            labels: ['موجود', 'ناموجود'],
            datasets: [{
                data: [availableVariable, outOfStockVariable],
                backgroundColor: ['#4CAF50', '#BE3436'],
            }]
        },
        options: {
            responsive: true,
            plugins: {
                legend: {
                    position: 'top',
                },
                tooltip: {
                    callbacks: {
                        label: function(tooltipItem) {
                            return tooltipItem.label + ': ' + tooltipItem.raw + ' محصول';
                        }
                    }
                }
            }
        }
    });
</script>
