<?php
// جلوگیری از دسترسی مستقیم
if (!defined('ABSPATH')) {
    exit;
}

// فرم HTML برای تغییر قیمت
?>
<!DOCTYPE html>
<html lang="fa">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>تغییر قیمت و تخفیف به صورت درصدی</title>
    <link href="https://fonts.googleapis.com/css2?family=Shabnam&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Shabnam', sans-serif;
            background-color: #f4f4f9;
            color: #333;
            direction: rtl;
            padding: 20px;
        }
        .container {
            width: 100%;
            max-width: 1200px;
            margin: 10px auto;
            padding: 20px;
            background-color: #ffffff;
            border-radius: 20px;
        }
        h2, h3 {
            text-align: center;
            color: #2d3e50;
        }
        .form-table {
            width: 100%;
            border-collapse: collapse;
            background-color: #f9f9f9;
        }
        .form-table th, .form-table td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: center;
            vertical-align: middle;
        }
        .form-table th {
            background-color: #2271b1;
            color: white;
        }
        .form-table tr:nth-child(even) {
            background-color: #f2f2f2;
        }
        .form-table tr:hover {
            background-color: #ddd;
        }
        .response-message {
            background-color: #eaf7e4;
            color: #4caf50;
            border: 1px solid #4caf50;
            padding: 15px;
            border-radius: 5px;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 20px auto;
            width: auto;
            max-width: 80%;
            opacity: 1;
            transition: opacity 0.5s ease-in-out;
        }
        .response-message.error {
            background-color: #f8d7da;
            color: #721c24;
            border: 1px solid #f5c6cb;
        }
        .message-icon {
            font-size: 20px;
            margin-right: 10px;
        }
        .message-text {
            font-weight: bold;
        }
        .button-primary {
            background-color: #2271b1;
            border-color: #2271b1;
            color: #fff;
            padding: 8px 16px;
            border-radius: 4px;
            font-size: 14px;
            cursor: pointer;
        }
        .button-primary:hover {
            background-color: #1e5b8e;
            border-color: #1e5b8e;
        }
        #select_all_btn, #reset_categories_btn {
            background-color: #4caf50;
            border-color: #4caf50;
            color: #fff;
            padding: 8px 16px;
            border-radius: 4px;
            font-size: 14px;
            cursor: pointer;
            margin-bottom: 10px;
            margin-left: 10px;
        }
        #select_all_btn:hover, #reset_categories_btn:hover {
            background-color: #45a049;
            border-color: #45a049;
        }
        @keyframes fadeIn {
            from {
                opacity: 0;
            }
            to {
                opacity: 1;
            }
        }
    </style>
</head>
<body>
<div class="container">
    <form method="post" action="">
        <?php wp_nonce_field('modirshop_price_adjustment_action', 'modirshop_price_adjustment_nonce'); ?>
        
        <h2>افزایش قیمت و تخفیف به صورت درصدی</h2>
        <div style="text-align: center;">این بخش قیمت اصلی و تخفیفی را به صورت همزمان به تفکیک دسته‌بندی "افزایش قیمت" می‌دهد.</div>
        <br>

        <!-- جدول نمایش دسته‌بندی‌ها -->
        <h3>مرحله 1) انتخاب دسته‌بندی‌ها</h3>
        <?php modirshop_categories_field_callback(); ?>
        
        <br><br>
        
        <!-- فیلدهای درصد تغییر قیمت و رند کردن -->
        <table class="form-table">
            <tr>
                <th><label for="modirshop_percentage">مرحله 2) درصد تغییر قیمت:</label></th>
                <td><input type="number" id="modirshop_percentage" name="modirshop_percentage" required style="width: 60px;" min="-100" max="100" value="10"> %</td>
                <td rowspan="2"> مرحله 4) <button type="submit" name="modirshop_update_prices" class="button button-primary" style=" font-size: 16px; background-color: #0b9f3f; border-color: #11853a; "> اعمال تغییرات</button></td>
            </tr>
            <tr>
                <th><label for="modirshop_rounding">مرحله 3) رند کردن (تعداد ارقام):</label></th>
                <td><input type="number" id="modirshop_rounding" name="modirshop_rounding" required style="width: 60px;" min="0" max="6" value="4"></td>
            </tr>
        </table>
    </form>

    <?php
    if (isset($_POST['modirshop_update_prices'])) {
        if (!isset($_POST['modirshop_price_adjustment_nonce']) || !wp_verify_nonce($_POST['modirshop_price_adjustment_nonce'], 'modirshop_price_adjustment_action')) {
            echo '<div class="response-message error"><span class="message-icon">❌</span> <span class="message-text">خطا: درخواست معتبر نیست.</span></div>';
        } elseif (empty($_POST['modirshop_categories'])) {
            echo '<div class="response-message error"><span class="message-icon">❌</span> <span class="message-text">خطا: هیچ دسته‌بندی‌ای انتخاب نشده است.</span></div>';
        } else {
            modirshop_update_prices();
        }
    } elseif (isset($_POST['modirshop_reset_categories'])) {
        delete_option('modirshop_categories');
        echo '<div class="response-message"><span class="message-icon">✅</span> <span class="message-text">دسته‌بندی‌های انتخاب‌شده بازنشانی شدند.</span></div>';
    }
    ?>
</div>

<script>
function showSuccessMessage(message) {
    let successMessage = document.createElement('div');
    successMessage.classList.add('response-message');
    successMessage.innerHTML = `<span class="message-icon">✅</span> <span class="message-text">${message}</span>`;
    
    document.querySelector('.container').prepend(successMessage);
    
    setTimeout(() => {
        successMessage.style.opacity = 0;
        setTimeout(() => {
            successMessage.remove();
        }, 500);
    }, 6000);
}
</script>
</body>
</html>

<?php
// تابع نمایش دسته‌بندی‌ها و تعداد محصولات
function modirshop_categories_field_callback() {
    $categories = get_terms(array(
        'taxonomy' => 'product_cat',
        'hide_empty' => false,
        'orderby' => 'name',
        'order' => 'ASC',
    ));

    // به‌صورت پیش‌فرض هیچ دسته‌بندی‌ای انتخاب نشود
    $selected_cats = [];
    
    // اگر فرم ارسال شده و دسته‌بندی‌ها انتخاب شده‌اند، از مقادیر ارسالی استفاده کن
    if (isset($_POST['modirshop_categories']) && is_array($_POST['modirshop_categories'])) {
        $selected_cats = array_map('intval', $_POST['modirshop_categories']);
        error_log('Selected Categories from POST: ' . print_r($selected_cats, true));
    }

    // دیباگ برای بررسی مقدار ذخیره‌شده
    $stored_cats = get_option('modirshop_categories', []);
    error_log('Stored Categories on Load: ' . print_r($stored_cats, true));

    $total_simple = 0;
    $total_variable = 0;

    echo '<button type="button" id="select_all_btn">انتخاب همه</button>';
    echo '<button type="submit" id="reset_categories_btn" name="modirshop_reset_categories">بازنشانی انتخاب‌ها</button>';
    echo '<table class="form-table" id="categories_table" style="width: 100%; margin-top: 20px;">';
    echo '<tr>
            <th style="width: auto;">ردیف</th>
            <th style="text-align: right; width: auto;">نام دسته</th>
            <th style="width: auto;">تعداد محصولات ساده</th>
            <th style="width: auto;">تعداد محصولات متغیر</th>
          </tr>';

    $row_count = 1;

    foreach ($categories as $category) {
        $counts = modirshop_count_products($category->term_id);
        $total_simple += $counts['simple'];
        $total_variable += $counts['variable'];

        error_log('Rendering Category: ' . $category->term_id . ' - ' . $category->name . ' - Checked: ' . (in_array($category->term_id, $selected_cats) ? 'Yes' : 'No'));

        echo '<tr>
                <td>' . $row_count++ . '</td>
                <td style="text-align: right;"><label><input type="checkbox" class="category-checkbox" name="modirshop_categories[]" value="' . $category->term_id . '" ' . (in_array($category->term_id, $selected_cats) ? 'checked' : '') . '> ' . $category->name . '</label></td>
                <td>' . $counts['simple'] . '</td>
                <td>' . $counts['variable'] . '</td>
              </tr>';
    }

    echo '<tr style="font-weight: bold; background-color: #f9f9f9;">
            <td>جمع کل:</td>
            <td></td>
            <td>' . $total_simple . '</td>
            <td>' . $total_variable . '</td>
          </tr>';
    echo '</table>';

    echo '<script>
        document.getElementById("select_all_btn").addEventListener("click", function() {
            let checkboxes = document.querySelectorAll(".category-checkbox");
            let allChecked = [...checkboxes].every(checkbox => checkbox.checked);
            checkboxes.forEach(checkbox => checkbox.checked = !allChecked);
        });
    </script>';
}

// تابع شمارش محصولات ساده و متغیر در هر دسته
function modirshop_count_products($category_id) {
    $args = array(
        'post_type' => 'product',
        'posts_per_page' => -1,
        'tax_query' => array(
            array(
                'taxonomy' => 'product_cat',
                'field' => 'term_id',
                'terms' => $category_id,
            ),
        ),
    );

    $products = get_posts($args);
    $simple_count = 0;
    $variable_count = 0;

    foreach ($products as $product) {
        $product_obj = wc_get_product($product->ID);
        
        if ($product_obj->is_type('simple')) {
            $simple_count++;
        } elseif ($product_obj->is_type('variable')) {
            $variable_count++;
        }
    }

    return array('simple' => $simple_count, 'variable' => $variable_count);
}

// تابع اعمال تغییر قیمت
function modirshop_update_prices() {
    global $wpdb;
    set_time_limit(600); // افزایش زمان اجرا برای فروشگاه‌های بزرگ

    $percentage = floatval($_POST['modirshop_percentage']);
    $rounding = isset($_POST['modirshop_rounding']) ? intval($_POST['modirshop_rounding']) : 4;
    $rounding = max(0, min($rounding, 6));
    $selected_categories = isset($_POST['modirshop_categories']) ? array_map('intval', (array) $_POST['modirshop_categories']) : [];
    $updated_count = 0;

    // دیباگ ورودی‌ها
    error_log('Percentage: ' . $percentage);
    error_log('Selected Categories: ' . print_r($selected_categories, true));

    if (empty($selected_categories)) {
        echo '<div class="response-message error"><span class="message-icon">❌</span> <span class="message-text">خطا: هیچ دسته‌بندی‌ای انتخاب نشده است.</span></div>';
        return;
    }

    // گرفتن تمام دسته‌بندی‌های موجود
    $all_categories = get_terms(array(
        'taxonomy' => 'product_cat',
        'hide_empty' => false,
        'fields' => 'ids',
    ));

    // اگر تمام دسته‌بندی‌ها انتخاب شده باشند، آپدیت مستقیم در دیتابیس
    if (!empty($selected_categories) && count($selected_categories) === count($all_categories) && empty(array_diff($selected_categories, $all_categories))) {
        error_log('Updating all categories via database query');
        
        // آپدیت قیمت‌های اصلی
        $wpdb->query(
            $wpdb->prepare(
                "UPDATE {$wpdb->postmeta} 
                SET meta_value = GREATEST(1000, ROUND(ROUND(CAST(meta_value AS DECIMAL(20,4)) * %f / POW(10, %d)) * POW(10, %d)))
                WHERE meta_key = '_regular_price' 
                AND meta_value REGEXP '^[0-9]+\\.?[0-9]*$'",
                1 + ($percentage / 100),
                $rounding,
                $rounding
            )
        );

        // آپدیت قیمت‌های تخفیفی
        $wpdb->query(
            $wpdb->prepare(
                "UPDATE {$wpdb->postmeta} 
                SET meta_value = GREATEST(1000, ROUND(ROUND(CAST(meta_value AS DECIMAL(20,4)) * %f / POW(10, %d)) * POW(10, %d)))
                WHERE meta_key = '_sale_price' 
                AND meta_value REGEXP '^[0-9]+\\.?[0-9]*$' 
                AND meta_value != ''",
                1 + ($percentage / 100),
                $rounding,
                $rounding
            )
        );

        // آپدیت قیمت واقعی (_price)
        $wpdb->query(
            $wpdb->prepare(
                "UPDATE {$wpdb->postmeta} pm1
                JOIN {$wpdb->postmeta} pm2 ON pm1.post_id = pm2.post_id AND pm2.meta_key = '_regular_price'
                LEFT JOIN {$wpdb->postmeta} pm3 ON pm1.post_id = pm3.post_id AND pm3.meta_key = '_sale_price'
                SET pm1.meta_value = CASE 
                    WHEN pm3.meta_value IS NOT NULL AND pm3.meta_value REGEXP '^[0-9]+\\.?[0-9]*$' AND pm3.meta_value != ''
                    THEN GREATEST(1000, ROUND(ROUND(CAST(pm3.meta_value AS DECIMAL(20,4)) * %f / POW(10, %d)) * POW(10, %d)))
                    ELSE GREATEST(1000, ROUND(ROUND(CAST(pm2.meta_value AS DECIMAL(20,4)) * %f / POW(10, %d)) * POW(10, %d)))
                END
                WHERE pm1.meta_key = '_price' 
                AND pm1.meta_value REGEXP '^[0-9]+\\.?[0-9]*$'",
                1 + ($percentage / 100),
                $rounding,
                $rounding,
                1 + ($percentage / 100),
                $rounding,
                $rounding
            )
        );

        $updated_count = $wpdb->get_var("SELECT COUNT(*) FROM {$wpdb->postmeta} WHERE meta_key = '_regular_price' AND meta_value REGEXP '^[0-9]+\\.?[0-9]*$'");
        wc_delete_product_transients();
    } else {
        $processed_products = [];

        foreach ($selected_categories as $category_id) {
            error_log('Processing Category ID: ' . $category_id);
            $args = array(
                'post_type' => 'product',
                'posts_per_page' => -1,
                'tax_query' => array(
                    array(
                        'taxonomy' => 'product_cat',
                        'field' => 'term_id',
                        'terms' => $category_id,
                    ),
                ),
            );

            $products = get_posts($args);

            foreach ($products as $product) {
                if (in_array($product->ID, $processed_products)) {
                    continue;
                }

                $product_obj = wc_get_product($product->ID);
                $processed_products[] = $product->ID;

                if ($product_obj->is_type('simple')) {
                    $price = floatval($product_obj->get_regular_price());
                    error_log('Processing Simple Product ID: ' . $product->ID . ', Regular Price: ' . $price);
                    if ($price > 0) {
                        $new_price = $price * (1 + $percentage / 100);
                        $new_price = round(round($new_price / pow(10, $rounding)) * pow(10, $rounding));
                        $new_price = max(1000, $new_price); // حداقل قیمت
                        $product_obj->set_regular_price($new_price);

                        $sale_price = $product_obj->get_sale_price();
                        if ($sale_price && floatval($sale_price) > 0) {
                            $new_sale_price = floatval($sale_price) * (1 + $percentage / 100);
                            $new_sale_price = round(round($new_sale_price / pow(10, $rounding)) * pow(10, $rounding));
                            $new_sale_price = max(1000, $new_sale_price); // حداقل قیمت
                            $product_obj->set_sale_price($new_sale_price);
                            update_post_meta($product->ID, '_price', $new_sale_price);
                        } else {
                            update_post_meta($product->ID, '_price', $new_price);
                        }
                        $product_obj->save();
                        $updated_count++;
                    } else {
                        error_log('Skipping Simple Product ID: ' . $product->ID . ' - Invalid or zero regular price');
                    }
                } elseif ($product_obj->is_type('variable')) {
                    $variations = $product_obj->get_children();

                    foreach ($variations as $variation_id) {
                        $variation = wc_get_product($variation_id);
                        $price = floatval($variation->get_regular_price());
                        error_log('Processing Variation ID: ' . $variation_id . ', Regular Price: ' . $price);
                        if ($price > 0) {
                            $new_price = $price * (1 + $percentage / 100);
                            $new_price = round(round($new_price / pow(10, $rounding)) * pow(10, $rounding));
                            $new_price = max(1000, $new_price); // حداقل قیمت
                            $variation->set_regular_price($new_price);

                            $sale_price = $variation->get_sale_price();
                            if ($sale_price && floatval($sale_price) > 0) {
                                $new_sale_price = floatval($sale_price) * (1 + $percentage / 100);
                                $new_sale_price = round(round($new_sale_price / pow(10, $rounding)) * pow(10, $rounding));
                                $new_sale_price = max(1000, $new_sale_price); // حداقل قیمت
                                $variation->set_sale_price($new_sale_price);
                                update_post_meta($variation_id, '_price', $new_sale_price);
                            } else {
                                update_post_meta($variation_id, '_price', $new_price);
                            }
                            $variation->save();
                            $updated_count++;
                        } else {
                            error_log('Skipping Variation ID: ' . $variation_id . ' - Invalid or zero regular price');
                        }
                    }
                }
            }
        }
        wc_delete_product_transients();
    }

    update_option('modirshop_categories', $selected_categories);
    echo "<script>window.onload = function() { showSuccessMessage('$updated_count محصول با موفقیت به‌روزرسانی شد.'); }</script>";
}
?>