<?php
// جلوگیری از دسترسی مستقیم
if (!defined('ABSPATH')) {
    exit;
}

// فرم HTML برای اعمال تخفیف
?>
<!DOCTYPE html>
<html lang="fa">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>تخفیف گذاشتن روی محصولات به تفکیک دسته‌بندی</title>
    <link href="https://fonts.googleapis.com/css2?family=Shabnam&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Shabnam', sans-serif;
            background-color: #f4f4f9;
            color: #333;
            direction: rtl;
            padding: 20px;
        }
        .container {
            max-width: 1200px;
            margin: 20px auto;
            padding: 20px;
            background-color: #ffffff;
            border-radius: 12px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
        }
        h2 {
            text-align: center;
            color: #2d3e50;
            margin-bottom: 10px;
        }
        .subtitle {
            text-align: center;
            color: #555;
            font-size: 16px;
            margin-bottom: 20px;
        }
        h3 {
            color: #2d3e50;
            margin-top: 30px;
            margin-bottom: 15px;
        }
        .form-table {
            width: 100%;
            border-collapse: collapse;
            background-color: #f9f9f9;
            border-radius: 8px;
            overflow: hidden;
        }
        .form-table th, .form-table td {
            border: 1px solid #ddd;
            padding: 12px;
            text-align: center;
            vertical-align: middle;
        }
        .form-table th {
            background-color: #2271b1;
            color: white;
            font-weight: bold;
        }
        .form-table tr:nth-child(even) {
            background-color: #f2f2f2;
        }
        .form-table tr:hover {
            background-color: #e6f0fa;
        }
        .input-group {
            display: flex;
            align-items: center;
            gap: 10px;
        }
        .input-group input[type="number"] {
            width: 80px;
            padding: 8px;
            border: 1px solid #ddd;
            border-radius: 4px;
            font-size: 14px;
        }
        .button-primary {
            background-color: #2271b1;
            border-color: #2271b1;
            color: #fff;
            padding: 10px 20px;
            border-radius: 6px;
            font-size: 16px;
            cursor: pointer;
            transition: background-color 0.3s ease;
        }
        .button-primary:hover {
            background-color: #1e5b8e;
            border-color: #1e5b8e;
        }
        #select_all_btn {
            background-color: #4caf50;
            border-color: #4caf50;
            color露

        .button-primary:hover {
            background-color: #45a049;
            border-color: #45a049;
        }
        .response-message {
            background-color: #eaf7e4;
            color: #4caf50;
            border: 1px solid #4caf50;
            padding: 15px;
            border-radius: 6px;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 20px auto;
            max-width: 80%;
            opacity: 1;
            transition: opacity 0.5s ease-in-out;
            animation: fadeIn 0.5s ease-in-out;
        }
        .response-message.error {
            background-color: #f8d7da;
            color: #721c24;
            border: 1px solid #f5c6cb;
        }
        .message-icon {
            font-size: 20px;
            margin-right: 10px;
        }
        .message-text {
            font-weight: bold;
            font-size: 16px;
        }
        @keyframes fadeIn {
            from { opacity: 0; }
            to { opacity: 1; }
        }
    </style>
</head>
<body>
<div class="container">
    <h2>تخفیف گذاشتن روی محصولات به تفکیک دسته‌بندی</h2>
    <div class="subtitle">این بخش قیمت اصلی را تغییر نمی‌دهد و فقط تخفیف اعمال یا حذف می‌کند.</div>
    <div class="subtitle">اگر درصد تخفیف 0 باشد، تخفیف‌ها حذف شده و قیمت نمایش به قیمت اصلی بازمی‌گردد.</div>

    <form method="post" action="">
        <?php wp_nonce_field('update_price_discount_action', 'price_discount_nonce'); ?>
        
        <h3>مرحله 1: انتخاب دسته‌بندی‌ها</h3>
        <?php display_product_categories(); ?>
        
        <h3>مرحله 2 و 3: تنظیم تخفیف و رند کردن</h3>
        <table class="form-table">
            <tr>
                <th><label for="discount_percentage">درصد تخفیف:</label></th>
                <td>
                    <div class="input-group">
                        <input type="number" id="discount_percentage" name="discount_percentage" required min="0" max="99" value="10">
                        <span>%</span>
                    </div>
                </td>
                <td rowspan="2">
                    <button type="submit" name="apply_price_changes" class="button button-primary">اعمال تغییرات</button>
                </td>
            </tr>
            <tr>
                <th><label for="modirshop_rounding">رند کردن (تعداد ارقام):</label></th>
                <td>
                    <div class="input-group">
                        <input type="number" id="modirshop_rounding" name="modirshop_rounding" required min="0" max="6" value="4">
                    </div>
                </td>
            </tr>
        </table>
    </form>

    <?php
    if (isset($_POST['apply_price_changes'])) {
        if (!isset($_POST['price_discount_nonce']) || !wp_verify_nonce($_POST['price_discount_nonce'], 'update_price_discount_action')) {
            echo '<div class="response-message error"><span class="message-icon">❌</span> <span class="message-text">خطا: درخواست معتبر نیست.</span></div>';
        } elseif (empty($_POST['selected_categories'])) {
            echo '<div class="response-message error"><span class="message-icon">❌</span> <span class="message-text">خطا: هیچ دسته‌بندی‌ای انتخاب نشده است.</span></div>';
        } else {
            update_discounted_prices();
        }
    }
    ?>
</div>

<script>
function showSuccessMessage(message) {
    let successMessage = document.createElement('div');
    successMessage.classList.add('response-message');
    successMessage.innerHTML = `<span class="message-icon">✅</span> <span class="message-text">${message}</span>`;
    
    document.querySelector('.container').prepend(successMessage);
    
    setTimeout(() => {
        successMessage.style.opacity = 0;
        setTimeout(() => {
            successMessage.remove();
        }, 500);
    }, 6000);
}
</script>
</body>
</html>

<?php
// تابع نمایش دسته‌بندی‌ها و تعداد محصولات
function display_product_categories() {
    $categories = get_terms(array(
        'taxonomy' => 'product_cat',
        'hide_empty' => false,
        'orderby' => 'name',
        'order' => 'ASC',
    ));
    $selected_category_ids = get_option('selected_categories', []);
    
    // اطمینان از اینکه selected_category_ids یک آرایه است
    if (!is_array($selected_category_ids)) {
        $selected_category_ids = is_string($selected_category_ids) ? maybe_unserialize($selected_category_ids) : [];
        if (!is_array($selected_category_ids)) {
            $selected_category_ids = [];
        }
    }

    $total_simple = 0;
    $total_variable = 0;

    echo '<button type="button" id="select_all_btn">انتخاب همه</button>';
    echo '<table class="form-table" id="categories_table">';
    echo '<tr>
            <th>ردیف</th>
            <th style="text-align: right;">نام دسته</th>
            <th>تعداد محصولات ساده</th>
            <th>تعداد محصولات متغیر</th>
          </tr>';

    $row_count = 1;

    foreach ($categories as $category) {
        $counts = count_products_in_category($category->term_id);
        $total_simple += $counts['simple'];
        $total_variable += $counts['variable'];

        echo '<tr>
                <td>' . $row_count++ . '</td>
                <td style="text-align: right;"><label><input type="checkbox" class="category-checkbox" name="selected_categories[]" value="' . $category->term_id . '" ' . (in_array($category->term_id, $selected_category_ids) ? 'checked' : '') . '> ' . $category->name . '</label></td>
                <td>' . $counts['simple'] . '</td>
                <td>' . $counts['variable'] . '</td>
              </tr>';
    }

    echo '<tr style="font-weight: bold; background-color: #f9f9f9;">
            <td>جمع کل:</td>
            <td></td>
            <td>' . $total_simple . '</td>
            <td>' . $total_variable . '</td>
          </tr>';
    echo '</table>';

    echo '<script>
        document.getElementById("select_all_btn").addEventListener("click", function() {
            let checkboxes = document.querySelectorAll(".category-checkbox");
            let allChecked = [...checkboxes].every(checkbox => checkbox.checked);
            checkboxes.forEach(checkbox => checkbox.checked = !allChecked);
        });
    </script>';
}

// تابع شمارش محصولات ساده و متغیر در هر دسته
function count_products_in_category($category_id) {
    $args = array(
        'post_type' => 'product',
        'posts_per_page' => -1,
        'tax_query' => array(
            array(
                'taxonomy' => 'product_cat',
                'field' => 'term_id',
                'terms' => $category_id,
            ),
        ),
    );

    $products = get_posts($args);
    $simple_count = 0;
    $variable_count = 0;

    foreach ($products as $product) {
        $product_obj = wc_get_product($product->ID);
        
        if ($product_obj->is_type('simple')) {
            $simple_count++;
        } elseif ($product_obj->is_type('variable')) {
            $variable_count++;
        }
    }

    return array('simple' => $simple_count, 'variable' => $variable_count);
}

// تابع اعمال تخفیف


function update_discounted_prices() {
    global $wpdb;
    set_time_limit(600); // افزایش زمان اجرا

    $discount_percentage = floatval($_POST['discount_percentage']);
    $rounding = isset($_POST['modirshop_rounding']) ? intval($_POST['modirshop_rounding']) : 4;
    $rounding = max(0, min($rounding, 6));
    $selected_category_ids = isset($_POST['selected_categories']) ? (array) $_POST['selected_categories'] : [];
    $updated_products_count = 0;

    // دیباگ ورودی‌ها
    error_log('Discount Percentage: ' . $discount_percentage);
    error_log('Selected Categories: ' . print_r($selected_category_ids, true));

    if (empty($selected_category_ids)) {
        echo '<div class="response-message error"><span class="message-icon">❌</span> <span class="message-text">خطا: هیچ دسته‌بندی‌ای انتخاب نشده است.</span></div>';
        return;
    }

    // گرفتن تمام دسته‌بندی‌ها
    $all_categories = get_terms(array(
        'taxonomy' => 'product_cat',
        'hide_empty' => false,
        'fields' => 'ids',
    ));

    // دیباگ تعداد دسته‌بندی‌ها
    error_log('Selected Categories Count: ' . count($selected_category_ids));
    error_log('All Categories Count: ' . count($all_categories));
    error_log('Array Diff: ' . print_r(array_diff($selected_category_ids, $all_categories), true));

    // غیرفعال کردن موقت شرط "همه دسته‌بندی‌ها" برای تست
    $processed_product_ids = [];

    foreach ($selected_category_ids as $category_id) {
        error_log('Processing Category ID: ' . $category_id);
        $args = array(
            'post_type' => 'product',
            'posts_per_page' => -1,
            'tax_query' => array(
                array(
                    'taxonomy' => 'product_cat',
                    'field' => 'term_id',
                    'terms' => $category_id,
                ),
            ),
        );

        $products = get_posts($args);

        foreach ($products as $product) {
            if (in_array($product->ID, $processed_product_ids)) {
                continue;
            }

            $product_obj = wc_get_product($product->ID);
            $processed_product_ids[] = $product->ID;

            if ($product_obj->is_type('simple')) {
                $regular_price = floatval($product_obj->get_regular_price());
                error_log('Processing Simple Product ID: ' . $product->ID . ', Regular Price: ' . $regular_price);
                if ($regular_price > 0) {
                    if ($discount_percentage == 0) {
                        $product_obj->set_sale_price('');
                        update_post_meta($product->ID, '_sale_price', '');
                        update_post_meta($product->ID, '_price', $regular_price);
                    } else {
                        $new_sale_price = $regular_price * (1 - $discount_percentage / 100);
                        $new_sale_price = round(round($new_sale_price / pow(10, $rounding)) * pow(10, $rounding));
                        if ($new_sale_price < 1000) {
                            $new_sale_price = 1000;
                        }
                        if ($new_sale_price < $regular_price) {
                            $product_obj->set_sale_price($new_sale_price);
                            update_post_meta($product->ID, '_sale_price', $new_sale_price);
                            update_post_meta($product->ID, '_price', $new_sale_price);
                        }
                    }
                    $product_obj->save();
                    $updated_products_count++;
                }
            } elseif ($product_obj->is_type('variable')) {
                $variations = $product_obj->get_children();
                foreach ($variations as $variation_id) {
                    $variation = wc_get_product($variation_id);
                    $regular_price = floatval($variation->get_regular_price());
                    error_log('Processing Variation ID: ' . $variation_id . ', Regular Price: ' . $regular_price);
                    if ($regular_price > 0) {
                        if ($discount_percentage == 0) {
                            $variation->set_sale_price('');
                            update_post_meta($variation_id, '_sale_price', '');
                            update_post_meta($variation_id, '_price', $regular_price);
                        } else {
                            $new_sale_price = $regular_price * (1 - $discount_percentage / 100);
                            $new_sale_price = round(round($new_sale_price / pow(10, $rounding)) * pow(10, $rounding));
                            if ($new_sale_price < 1000) {
                                $new_sale_price = 1000;
                            }
                            if ($new_sale_price < $regular_price) {
                                $variation->set_sale_price($new_sale_price);
                                update_post_meta($variation_id, '_sale_price', $new_sale_price);
                                update_post_meta($variation_id, '_price', $new_sale_price);
                            }
                        }
                        $variation->save();
                        $updated_products_count++;
                    }
                }
            }
        }
    }

    wc_delete_product_transients();
    update_option('selected_categories', $selected_category_ids);
    echo "<script>window.onload = function() { showSuccessMessage('$updated_products_count محصول با موفقیت به‌روزرسانی شد.'); }</script>";
}
?>